// AlifeView.cpp : implementation of the CAlifeView class
//

#include "stdafx.h"
#include "Alife.h"

#include "AlifeDoc.h"
#include "AlifeView.h"
#include "MainFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAlifeView

IMPLEMENT_DYNCREATE(CAlifeView, CView)

BEGIN_MESSAGE_MAP(CAlifeView, CView)
	//{{AFX_MSG_MAP(CAlifeView)
	ON_WM_LBUTTONDOWN()
	ON_WM_MOUSEMOVE()
	ON_COMMAND(ID_FILE_PAUSE, OnFilePause)
	ON_UPDATE_COMMAND_UI(ID_FILE_PAUSE, OnUpdateFilePause)
	ON_WM_SIZE()
	ON_COMMAND(ID_CONTROLS_SCORE, OnControlsScore)
	ON_WM_SETFOCUS()
	ON_COMMAND(ID_CONTROLS_PARAMS, OnControlsParams)
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
	/* ON_COMMAND_RANGE is a macro that maps a given range of select
		control IDs to the indicated message handler, which will have an
		nID argument equal to the control's ID. I have to type this in by
hand, I can't add it with Class Wizard. */
	ON_COMMAND_RANGE(DEM_MIXED, DEM_HOMEWORK, OnDemo)
	ON_COMMAND_RANGE(ID_FIT_VARY, ID_FIT_SQUEEZE, OnFit)
	/*ON_UPDATE_COMMAND_UI_RANGE is a macro that maps a given range of update
		control IDs to the indicated message handler, which will have an
		argument that is a pointer to a CCmdUI object.  This object has a
		m_nID field with the ID of the control and it has a SetCheck 
		method. */
	ON_UPDATE_COMMAND_UI_RANGE(DEM_MIXED, DEM_HOMEWORK, OnDemoUpdate)
	ON_UPDATE_COMMAND_UI_RANGE(ID_FIT_VARY, ID_FIT_SQUEEZE, OnFitUpdate)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAlifeView construction/destruction

CAlifeView::CAlifeView():
_fitmode(ID_FIT_VARY),
_bWorldCursor(FALSE)
{
	/* Don't try to use the CWnd for OnFit(_fitmode) here,
		as it's not really ready. Do the fitting in OnSize. */
}

CAlifeView::~CAlifeView()
{
}

BOOL CAlifeView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CAlifeView drawing

void CAlifeView::OnDraw(CDC* pDC)
{
	CAlifeDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
//My code
	CRect rect;
	pDC->GetClipBox(&rect);
	if (!pDC->IsPrinting()) //Writing to an onscreen window
	{
/* We distinguish three cases of _fitmode: ID_FIT_CLIP, ID_FIT_VARY, ID_FIT_SQUEEZE.
In the first two cases we do a simple pixel for pixel BitBlt copyTo.  In the 
last case we are doing a StretchBlt stretchTo call to squeeze the whole _pMemDC
into the visible window.  The CAlifeView _stretch_rect member is set in the
CAlifeView::OnSize function.  When this is set, the window is set so that its 
client size matches _stretch_rect.  If we give no third argument to stretchTo,
this means use the default ST_NON_ISO third argument which means don't recompute
the rectangle you are to stretch to. */
		if (_fitmode != ID_FIT_SQUEEZE)
			(GetDocument()->_pMemDC)->copyTo(pDC, &rect);
		else //ID_FIT_SQUEEZE case 
		{ 
			resizeFrameWindow(_stretch_cx, _stretch_cy);
			/*The reason for the resizeFrameWindow call is that when I 
				resize my window, the child frame window holding it will
				revert to the dragged, rather than the _stretch_c? based,
				size so I need to call resizeFrameWindow additional 
				times. */
			(GetDocument()->_pMemDC)->stretchTo(pDC, &_stretch_rect);
		} 
	}
	else //Writing to the printer or to a Print Preview window.
		(GetDocument()->_pMemDC)->stretchTo(pDC, &rect, ST_ISO_USE_WHOLE_SOURCE); 
	/* When the pDC is for print or print preview, it has a clip box rect of
	something like (-10, -10, 2000, 3000), and what happens if you do CopyTo
	is that you don't see anything at all.  Maybe your image gets squeezed up
	near (-10, -10), which isn't even visible in the print preview (off the
	upper left corner of the page). So we use a  cMemoryDC::stretchTo instead
	of the cMemoryDC::copyTo.  copyTo uses a straight BitBlt, while the
	stretchTo uses a StretchBlt.
		The third argument to stretchTo holds flags; ST_SMALL means fit the 
	whole source isotropically into the target, possibly with borders left 
	over; ST_BIG means cover the whole target with an isotropic stretch, 
	possibly not using all of the source.  In either of these two cases
	the actual rectangle to stretch to is computed from the rect using the
	global adjustStretch function that lives in cMemoryDC.h.
	*/
}

/////////////////////////////////////////////////////////////////////////////
// CAlifeView printing
BOOL temp_animate_flag;

BOOL CAlifeView::OnPreparePrinting(CPrintInfo* pInfo)
{
	temp_animate_flag = GetDocument()->_animate_flag;
	GetDocument()->_animate_flag = FALSE;
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CAlifeView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CAlifeView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// My cleanup after printing
	GetDocument()->_animate_flag = temp_animate_flag;
}

/////////////////////////////////////////////////////////////////////////////
// CAlifeView diagnostics

#ifdef _DEBUG
void CAlifeView::AssertValid() const
{
	CView::AssertValid();
}

void CAlifeView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CAlifeDoc* CAlifeView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CAlifeDoc)));
	return (CAlifeDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CAlifeView message handlers

void CAlifeView::viewToDoc(CPoint &pt)
{ /* This helper method is used in setCursorVector for the _fitmode ID_FIT_SQUEEZE case
	if ID_FIT_SQUEEZE, we keep the Document's cMemoryDC image as a fixed size 
that we squeeze this view into the View windows.  When I click in a View
window I need to turn that into an appropriate coordinate for the cMemoryDC.
	dc_x / wnd_x = dc_cx / wnd_cx, so
	dx_x = wnd_x * (dc_cx / wnd_cx).
We'll get wnd_? from the _stretch_rect and dc_? from the _pMemDC. To be safe 
check against a division by 0. */
	if (!_stretch_cx || !_stretch_cy)
		return;
	pt.x = (int)(pt.x * ((float)((GetDocument()->_pMemDC)->cx()) / _stretch_cx));
	pt.y = (int)(pt.y * ((float)((GetDocument()->_pMemDC)->cy()) / _stretch_cy));
}


void CAlifeView::OnDemo(UINT nID) 
{
	GetDocument()->setDemoType(nID);
/*
	I need to call this to set the values of _scalex and _scaley in
	the new Critters, to make _icon be the right size copy of _icon_fullsize */
	CRect rect;
	GetClientRect(rect);
	OnSize(SIZE_RESTORED, rect.right, rect.bottom);	

}

void CAlifeView::OnDemoUpdate(CCmdUI *pCmdUI) 
{/*This handler will be called for each of the tool control codes, passing in a
	pointer to the CCmdUI object corresponding to the control. This object has a
	m_nID field with the ID of the control and it has a SetCheck method.
	We use the CCmdUI SetCheck method, which can have an argument of 0, 1, or 2 
	(2 is for	indeterminate, used only on toolbars).*/ 
	int isactive = (pCmdUI->m_nID == GetDocument()->_demotype)?1:0;
	pCmdUI->SetCheck(isactive);
}

void CAlifeView::OnFit(UINT nID) 
{ //To see the real effect of these changes, look at CALifeView::OnDraw.
	CRect rect;
	_fitmode = nID;
	switch (_fitmode)
	{
		case ID_FIT_VARY: /* Change _frame so _pMemDC image matches this 
				window size. */
			GetClientRect(&rect);
			GetDocument()->_frame.SetPixelWindow(rect.right, rect.bottom);
			break;
		case ID_FIT_CLIP: //Use all of _pMemDC for the image
			GetDocument()->_frame.SetPixelWindow(GetDocument()->
				_pMemDC->cx(), GetDocument()->_pMemDC->cy());
			break;
case ID_FIT_SQUEEZE: // Use all of _pMemDC for the image
			GetDocument()->_frame.SetPixelWindow(GetDocument()->
				_pMemDC->cx(),
				GetDocument()->_pMemDC->cy());
			CRect rect;
			GetClientRect(&rect);
			OnSize(SIZE_RESTORED, rect.right, rect.bottom);	
				/* SIZE_RESTORED is 0, means a normal resize by dragging, 
				we call this so as to set a bunch of things for the 
				stretch. */		
			break;
	}
	InvalidateRect(NULL, TRUE); //Erase the background in case there's extra space
}

void CAlifeView::OnFitUpdate(CCmdUI *pCmdUI) 
{// See On Demo Update
	int isactive = (pCmdUI->m_nID == _fitmode)?1:0;
	pCmdUI->SetCheck(isactive);
}

void CAlifeView::setCursorVector(CPoint point)
{
	Real rx, ry;

	if (_fitmode == ID_FIT_SQUEEZE)
		viewToDoc(point);
GetDocument()->_frame.PixelToReal(point.x, point.y, &rx, &ry);
	GetDocument()->_world.Set_cursorvector(Vector2(rx, ry));
}


void CAlifeView::OnLButtonDown(UINT nFlags, CPoint point) 
{
/* Sometimes you don't want to drag a CursorCritter around, you might want to 
use your cursor to go up and click in a menu.  So we use left click to toggle
this on and off. But always assume a click means "move here." */
	_bWorldCursor ^= TRUE;
	setCursorVector(point);
}

void CAlifeView::OnMouseMove(UINT nFlags, CPoint point) 
{
	if (_bWorldCursor)
		setCursorVector(point);
}

void CAlifeView::OnFilePause() 
{
	GetDocument()->_animate_flag ^= TRUE;	
}

void CAlifeView::OnUpdateFilePause(CCmdUI* pCmdUI) 
{
	int isactive = GetDocument()->_animate_flag?0:1;
	pCmdUI->SetCheck(isactive);
}

void CAlifeView::OnSize(UINT nType, int cx, int cy) 
{
	/*For a child client window like a View, you ONLY get this message with
nType == 0, which means SIZE_RESTORED, which means the case other than
SIZE_MINIMIZED, or SIZE_MAXIMIZED.  You never get those two down here in View;
they go to the frame instead. */

//	CView::OnSize(nType, cx, cy);   //Default seems unnecessary
	GetDocument()->_critterlist->world()->resetTimeAdjuster();
	switch(_fitmode)
	{
		case ID_FIT_CLIP:
			/* Don't need to do anything.  Store the size in _stretch in 
				case you suddenly switch _fitmode */
			_stretch_cx = cx;
			_stretch_cy = cy;
			_stretch_rect = CRect(0,0,cx,cy);
			break;
		case ID_FIT_VARY:
			GetDocument()->_frame.SetPixelWindow(cx, cy);
// Store the size in _stretch just in case you need it.
			Real scalefactor_x, scalefactor_y;
			scalefactor_x = (Real)cx / GetDocument()->_pMemDC->cx();
			scalefactor_y = (Real)cy / GetDocument()->_pMemDC->cy();
			GetDocument()->_critterlist->scaleIcon(scalefactor_x, scalefactor_y);
			_stretch_cx = cx; _stretch_cy = cy; _stretch_rect = 
				CRect(0,0,cx, cy);
			break;
		case ID_FIT_SQUEEZE:
			adjustStretch(GetDocument()->_pMemDC->cx(), 
				GetDocument()->_pMemDC->cy(),
				cx, cy, _stretch_cx, _stretch_cy, ST_ISO_USE_WHOLE_SOURCE);
			_stretch_rect = CRect(0, 0, _stretch_cx, _stretch_cy);
				/* ST_ISO_COVER_TARGET does not seem to work well here.  
				It means stretch isometrically to something larger than 
				the window. ST_ISO_USE_WHOLE_SOURCE means something 
				smaller.   ST_NON_ISO SAYS just fill. ST_INTEGER
				means to use a (more rapid) integer or integer-reciprocal 
				stretch ratio.  Once we get the stretch_c? sizes here, we
				use a straight stretchTo in OnDraw.  Look in cMemoryDC3.h 
for other possible flag options to give adjustStretch. */
			resizeFrameWindow(_stretch_cx, _stretch_cy);
			_resized = TRUE;
			break;
		} //end _fitmode switch
}

void CAlifeView::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint) 
{
	// My Code
	InvalidateRect(NULL, FALSE); //Instead of default InvalidateRect(NULL, TRUE)
	UpdateWindow();	
	CScore *pDlg_score = ((CMainFrame *)AfxGetMainWnd())->_pDlg_score;
		/* Program will crash if we call UpdateData when the dialog isn't open. 
		 And we only want to update if this view is the focus. */
	if (pDlg_score->GetSafeHwnd() && pDlg_score->_pView_focus == this)
	{
		pDlg_score->m_score = GetDocument()->_critterlist->Focus()->score();
		pDlg_score->UpdateData(FALSE);
	}
}

void CAlifeView::resizeFrameWindow(int cx, int cy)
{
	CRect client_rect;
	GetClientRect(&client_rect);
	if (client_rect.right == cx && client_rect.bottom == cy)
		return;
/* In the following lines I try and resize the window to match _stretch_c?.
This is tricky.
	This CView window is a child client window whose parent is a child
frame window.  The parent of the childframe is a mdiclient window, whose parent
is the mdiframe and is the same as the top level AfxGetMainWnd().  [I left in
some commented out lines you can comment in and then set a break point and use
the debugger watch window to see that mdiframe and mainwnd really are the same.]
	When I do GetWindowRect this returns screen coordinates. But when I do a
MoveWindow(left, top, cx, cy), the left and top are in the coordinates of the
client area of the parent of the window.  And the size of a window needs to
include the size in the borders and the caption bar.
	One gotcha is that a MoveWindow call here sends a WM_SIZE to the caller 
window, which calls the OnSize function which called the MoveWindow in the first 
place.  If I only call the MoveWindow for the parent window, this gotcha doesn't 
arise, but if I call MoveWindow for this caller CView I would need an 
in_movewindow flag to block the endless regress. */
			//CView *this is the bottom level CWnd. 
			 
			CWnd *childframe = GetParent(); //The frame that holds the view
			CRect  screen_rect_frame;
			childframe->GetWindowRect(&screen_rect_frame);
			int old_cx = screen_rect_frame.right - screen_rect_frame.left;
			int old_cy = screen_rect_frame.bottom - screen_rect_frame.top;
			int new_cx = cx + 2 * GetSystemMetrics(SM_CXBORDER);
			int new_cy = cy + 2* GetSystemMetrics(SM_CYBORDER) +
			 	GetSystemMetrics(SM_CYMENU);
			if (old_cx == new_cx && old_cy == new_cy)
				return;
			CWnd *mdiclient = childframe->GetParent();
				 //The mdi window where the views sit
//			CWnd *mdiframe = mdiclient->GetParent();
				 //The frame of the mdi window 
//			CWnd *mainwnd = AfxGetMainWnd(); //The same as mdiframe.
			CRect screen_rect_mdi;
			mdiclient->GetWindowRect(&screen_rect_mdi);
/* The code up through the next switch is because the corner position of a window
depends on whether or not its maximized.  If I don't do this and try and use the
same dx, dy for both the SW_SHOWNORMAL and SW_SHOWMAXIMIZED cases, then the
repeated calls to MoveWindow will make the window drift up and to the left or
down and to the bottom in one case or the other. */
			WINDOWPLACEMENT wp;
			childframe->GetWindowPlacement(&wp);
			int dx, dy;
			switch(wp.showCmd)
			{
				case SW_SHOWMINIMIZED:
					return; //No point doing anything
				case SW_SHOWNORMAL:
					dx = 2*GetSystemMetrics(SM_CXBORDER);
					dy = 2*GetSystemMetrics(SM_CYBORDER);
					break;
				case SW_SHOWMAXIMIZED:
					dx = 0; //GetSystemMetrics(SM_CXBORDER);
					dy = 0; //GetSystemMetrics(SM_CYBORDER);
					break;
			}
			childframe->MoveWindow(
				screen_rect_frame.left - screen_rect_mdi.left - dx,
				screen_rect_frame.top - screen_rect_mdi.top - dy,
				new_cx, new_cy,	TRUE); 
				/* The last TRUE argument means repaint the background 
				(the mdiclient) after the resize of the childframe, which 
				you definitely want to do. */
}

void CAlifeView::OnControlsScore() 
{
	CScore *pDlg_score = ((CMainFrame *)AfxGetMainWnd())->_pDlg_score;
		/* Program will crash if you try to open a modeless dialog twice.
		If the HWND isn't NULL, it's already open. */
	if (pDlg_score->GetSafeHwnd())
		return;
	pDlg_score->m_score = GetDocument()->_critterlist->Focus()->score();
	pDlg_score->Create(IDD_SCORE);
}

void CAlifeView::OnSetFocus(CWnd* pOldWnd) 
{
	CView::OnSetFocus(pOldWnd);
	
	/* The score code.  The m_score field is updated and displayed
		at each step of CAlifeView::OnUpdate(), so we don't have to
		do it here. */
	((CMainFrame *)AfxGetMainWnd())->_pDlg_score->_pView_focus = this;

	/* The params code.  To save typing here, we use a pDlg_params variable
		to stand for a longer expression. */
	CParams *pDlg_params = ((CMainFrame *)AfxGetMainWnd())->_pDlg_params;
	pDlg_params->_pView_focus = this;
	pDlg_params->m_runspeed = runspeed();
	if (pDlg_params->GetSafeHwnd()) //Modeless dialog open
		pDlg_params->UpdateData(FALSE); //Display the data
}

void CAlifeView::OnControlsParams() 
{
	/* To save typing here, we use a pDlg_params variable
		to stand for a longer expression. */
	CParams *pDlg_params = ((CMainFrame *)AfxGetMainWnd())->_pDlg_params;
	if (pDlg_params->GetSafeHwnd()) //Modeless dialog open
		return; //Don't try to open it twice
	pDlg_params->Create(IDD_PARAMS); /* Show it!  Remember that a
		modeless dialog won't show unless it has Visible checked in
		the Resource Workshop properties|More Styles sheet. */	
	/* We don't need to set the pDlg_params _pView_focus or
		m_runspeed fields, as those were set in OnSetFocus. */	
}
